{ ------------------------------------------------------------------------ }
{   Title     : DEMOCD.PAS                           ** TP6 Version ***    }
{                                                                          }
{   Copyright (c) Creative Technology Pte Ltd, 1991. All rights reserved.  }
{ ------------------------------------------------------------------------ }

program democd;

{ Include the SBC Unit, and any other units needed }
uses sbc_tp6, dos, crt;


var
    dummy : integer;

{ ------------------------------------------------------------------------ }

procedure Display;
begin
    ClrScr;
    writeln('Compact Disc Player Demo Program');
    writeln;
    writeln('     P  : Play');
    writeln('     S  : Stop');
    writeln('     A  : Pause');
    writeln('     C  : Continue');
    writeln('     N  : Next Track');
    writeln('     L  : Previous Track');
    writeln('     F  : Fast Forword');
    writeln('     R  : Rewind');
    writeln('     Q  : Quit');
    writeln;
    writeln;
end;


{ ------------------------------------------------------------------------ }

function BCD2Binary (data : byte) : byte;
begin
    BCD2Binary := (data shr 4)*10 + (data and $f);
end;


{ ------------------------------------------------------------------------ }

function HSG2RED(data : longint) : longint;
var
    v0, v1, v2 : longint;

begin
    v2 := data div 4500;    { 4500 = 60 * 75 }
    v1 := (data mod 4500) div 75;
    v0 := (data mod 4500) mod 75;

    HSG2RED := (v2 shl 16) or (v1 shl 8) or v0;
end;


{ ------------------------------------------------------------------------ }

procedure ShowInfo;
var
    qch_info : QCHAN_INFO;
    volume : longint;
    vol1, vol2 : byte;

begin
    dummy := sbcd_get_loc_info( qch_info );
    dummy := sbcd_get_volume( volume );
    volume := HSG2RED( volume );

    vol1 := byte((volume shr 16) and $ff);
    vol2 := byte((volume shr 8) and $ff);

    write('Disc - ', qch_info.pmin:2,':', qch_info.psec:2,
          '  Track - ', BCD2Binary(qch_info.tno):2, ' ',
          qch_info.min:2, ':', qch_info.sec:2,
          '  Vol - ', vol1:2, ':', vol2:2, #13);

end;


{ ------------------------------------------------------------------------ }

const
    SKIP_SEC    = 16;

var
    key : char;
    drv_num : integer;
    quit : boolean;

{ main function }

begin  { program body }

    quit := False;

    if sbcd_init(drv_num) = 0 then begin

        Display;

        repeat
            ShowInfo;

            if keyPressed then begin
                key := ReadKey;

                { not extended key }
                if (key <> #0) then begin
                    key := UpCase(key);

                    case (key) of
                        'P' :
                            dummy := sbcd_play(1,0,$ffff);
                        'S' :
                            dummy := sbcd_stop;
                        'A' :
                            dummy := sbcd_pause;
                        'C' :
                            dummy := sbcd_continue;
                        'N' :
                            dummy := sbcd_next_track;
                        'L' :
                            dummy := sbcd_prev_track;
                        'F' :
                            dummy := sbcd_fastforward(SKIP_SEC);
                        'R' :
                            dummy := sbcd_rewind(SKIP_SEC);
                        'Q' :
                            quit := True;
                    end;
                end
                else
                    key := ReadKey;
            end;
        until quit;
    end
    else
        writeln('Initialization error.');
end.
